//
//  NSArray+MCFiltering.h
//  MCFoundation
//
//  Created by aj on Wed Oct 17 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//


/*

Creates a new array with objects that return a non-null or non-zero argument of the passed in selector

*/

#import <Foundation/Foundation.h>

@interface NSArray (MCFiltering)

- (NSArray *)filteredArrayUsingSelector:(SEL)aSel;
- (NSArray *)filteredArrayUsingSelector:(SEL)aSel withArgument:(id)anArg;
- (NSArray *)filteredArrayUsingSelector:(SEL)aSel withArgument:(id)anArg andArgument:(id)secondArg;

- (NSArray *)filteredArrayUsingSelector:(SEL)aSel sortKey:(NSString *)sortKey;

//
// Expects an array of MCActionArgumentContainer
- (NSArray *)filteredArrayMatchingAllActionArguments:(NSArray *)anArray;
- (NSArray *)filteredArrayMatchingSomeActionArguments:(NSArray *)anArray;

- (NSArray *)filteredArrayWhereAttributeNamed:(NSString *)aName isLike:(id)anObj;

- (id)objectWithAttribute:(NSString *)attr equalTo:(id)value;

- (NSArray*)filteredArrayWhereStringAttributeName:(NSString*)attrib 
                                  isEqualToString:(NSString*)anObj 
                           caseInsensitiveCompare:(BOOL)caseFlag;

- (NSArray *)filteredArrayUsingPredicateFormat:(NSString *)aFormat;
@end

@interface NSObject (MCFiltering)

- (id)attributeNamed:(NSString *)aName matches:(id)obj;

- (id)attributeNamed:(NSString *)aName matchesIntegerValue:(NSNumber *)obj;
- (id)attributeNamed:(NSString *)aName matchesLongLongValue:(NSNumber *)obj;


- (NSArray *)filteredArrayOfAttributeName:(NSString *)arrayAttr 
	whereObjectAttributeName:(NSString *)attr matches:(id)obj;

- (NSArray *)filteredArrayOfAttributeName:(NSString *)arrayAttr 
	whereObjectAttributeName:(NSString *)attr matchesIntegerValue:(NSNumber *)obj;

// throw exceptions MCInvalidRelationshipTypeException
// does an isEqual instead of ==
- (id)filteredArrayOfAttributeName:(NSString *)relKey whereAttributeName:(NSString *)attrib isEqualTo:(id)anObject;
// does case insensitive compare
- (id)filteredArrayOfAttributeName:(NSString *)relKey whereStringAttributeName:(NSString *)attrib isEqualToString:(NSString *)anObject;

// does localizedCaseInsensitvie compare
- (id)filteredArrayOfAttributeName:(NSString *)relKey whereStringAttributeName:(NSString *)attrib isEqualToLocalizedString:(NSString *)anObject;
@end
